import { ConfigService } from '@nestjs/config';
import Stripe from 'stripe';
export declare class StripeService {
    private configService;
    private stripe;
    constructor(configService: ConfigService);
    createPaymentIntent(amount: number, currency?: string, metadata?: any): Promise<{
        clientSecret: string | null;
        paymentIntentId: string;
        amount: number;
        currency: string;
    }>;
    confirmPayment(paymentIntentId: string): Promise<{
        success: boolean;
        paymentIntent: Stripe.Response<Stripe.PaymentIntent>;
    }>;
    createRefund(paymentIntentId: string, amount?: number): Promise<Stripe.Response<Stripe.Refund>>;
    handleWebhook(payload: Buffer, signature: string, webhookSecret: string): Promise<Stripe.Event>;
}
